// pages/debug.tsx
import useSWR from "swr";
import Link from "next/link";
const fetcher = (u: string) => fetch(u).then((r) => r.json());

export default function Debug() {
  const { data } = useSWR("/api/debug/whoami", fetcher, { refreshInterval: 0 });
  return (
    <main style={{ padding: 24, fontFamily: "ui-sans-serif, system-ui" }}>
      <h1>Session Debug</h1>
      <p>
        <Link href='/login'>/login</Link> &middot; <Link href='/'>home</Link>
      </p>
      <pre style={{ background: "#f6f6f6", padding: 12 }}>
        {JSON.stringify(data, null, 2)}
      </pre>
    </main>
  );
}
